 IF EXISTS (SELECT * FROM SYS.VIEWS	WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_ANALISE_CFOP]'))
	DROP VIEW [DBO].[V_EST_ANALISE_CFOP]

GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 250424
'Job.................:  
'Nome................: [V_EST_ANALISE_CFOP]
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 24/04/2025
'Criado por..........: 
'Alterado por........: Shirlene
'Versionado por......: Marcos Barros
'=======================================================================================
*/

CREATE VIEW [DBO].[V_EST_ANALISE_CFOP]
WITH ENCRYPTION
AS
	SELECT
		EST_NF_ENT_IT.CD_EMP
		,EST_NF_ENT_IT.CD_FILIAL
		,EST_NF_ENT_IT.DT_ENT
		,0                                                                                                     AS CD_CX
		,V_EST_NF_ENT_CAB.NR_NF                                                                                AS NR_DOC
		,GLB_NT_OP.CD_NT_OP_FC                                                                                 AS CFOP
		,SUM(ROUND(CONVERT(FLOAT, EST_NF_ENT_IT.VLR_TOT_IT) / CONVERT(FLOAT,
															   CASE
																   WHEN EST_NF_ENT_IT.QT_IT = 0 THEN 1
																   ELSE EST_NF_ENT_IT.QT_IT
															   END) * EST_NF_ENT_IT.QT_IT,2 ) - EST_NF_ENT_IT.VLR_DESC) 
					 + SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS)
					 + SUM(EST_NF_ENT_IT.VLR_IPI)
					 + ISNULL(SUM(EST_NF_ENT_IT.VLR_FRETE_IT), 0)
					 + ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_ST),0)
					 + SUM(EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS) 
					 - SUM (CASE WHEN ISNULL(V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) = 0   THEN 0 ELSE -- CASE ADICIONADO
					 ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) END ) AS VLR_CONTAB
		,CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1 THEN
		  0
		ELSE
		    CASE WHEN (EST_TRIB.ICMS = 1 ) OR (EST_TRIB.SUBS_TRIB = 1 AND V_EST_NF_ENT_CAB.TP_MOV IN(11)) THEN
				SUM(EST_NF_ENT_IT.VLR_BASE_ICMS)
			ELSE
				0
			END  
		 END VLR_BASE_ICMS
		 --FIM BASE ICMS

		 --ALIQ ICMS

		,CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1   THEN
			0
		 ELSE
			CASE WHEN (EST_TRIB.ICMS = 1) OR (EST_TRIB.SUBS_TRIB = 1 AND V_EST_NF_ENT_CAB.TP_MOV IN(11)) THEN
				EST_NF_ENT_IT.ALIQ_ICMS
			ELSE
				0
			END   
		 END ALIQ_ICMS
	      -- FIM ALIQ ICMS

		 -- VALOR ICMS 
		,CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1  THEN
		  0
		ELSE
		    CASE WHEN (EST_TRIB.ICMS = 1   OR GLB_MOV_OP.TP_MOV IN (58)) OR (EST_TRIB.SUBS_TRIB = 1 AND V_EST_NF_ENT_CAB.TP_MOV IN(11)) THEN
		
				SUM(EST_NF_ENT_IT.VLR_ICMS_IT)
			ELSE
			    0
			END															  
		 END VLR_ICMS
		 -- FIM VALOR ICMS                                                                                                  
		,
		CASE WHEN EST_TRIB.ISENTO = 0 THEN 0
		ELSE
		CASE WHEN EST_TRIB.ICMS = 0 AND
					EST_TRIB.ISENTO = 0 THEN 0
		 ELSE
			 CASE WHEN EST_TRIB.ISENTO = 0 THEN
				 CASE WHEN ( EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT ) = 0 THEN
					 CASE WHEN SUM((ROUND(EST_NF_ENT_IT.VLR_IT * EST_NF_ENT_IT.QT_IT,2 ) - EST_NF_ENT_IT.VLR_DESC)- EST_NF_ENT_IT.VLR_BASE_ICMS) > 0 THEN 
						SUM((ROUND ( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT,2 ) - ( EST_NF_ENT_IT.VLR_DESC + ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) ) - EST_NF_ENT_IT.VLR_BASE_ICMS ))
					 ELSE 0
					 END
				 ELSE 0
				 END
			 ELSE
			     CASE WHEN EST_TRIB.ISENTO = 1 THEN
					ROUND(SUM((ROUND ( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT,2 ) - ( EST_NF_ENT_IT.VLR_DESC + ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) ) )), 2)
				  ELSE
					 CASE WHEN ( EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT ) = 0 THEN
						 CASE WHEN SUM( ROUND(EST_NF_ENT_IT.VLR_IT * EST_NF_ENT_IT.QT_IT,2 ) - EST_NF_ENT_IT.VLR_DESC) > 0 THEN ROUND(SUM((ROUND ( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT,2 ) - ( EST_NF_ENT_IT.VLR_DESC + ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) ) )), 2)
						 ELSE 0
						 END
					 ELSE 0
					 END
                  END
			 END
		 END END  
		 
		 +  
		 CASE WHEN EST_TRIB.ICMS_RD = 1 and   ISNULL(PRC_FILIAL_CONFIG.VALOR,0)  = 1 THEN   
			SUM((ROUND(EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)-EST_NF_ENT_IT.VLR_BASE_ICMS) 	
		 ELSE 0
		 END                                                                                             AS VLR_ISENTO
		
		,0                                                                                                     AS VLR_SERVICO
		,CASE WHEN EST_TRIB.SUBS_TRIB = 1 THEN SUM(EST_NF_ENT_IT.VLR_BASE_SUBS)
		 ELSE 0
		 END                                                                                                   AS VLR_BASE_SUBS
		,CASE WHEN EST_TRIB.SUBS_TRIB = 1 THEN SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS)
		 ELSE 0
		 END                                                                                                   AS VLR_ICMS_SUBS
		,0                                                                                                     AS VLR_ICMS_SUBS_DARE
		,'ENTRADA'                                                                                             AS TIPO
		,'NOTA FISCAL'                                                                                         AS TIPO_DOC
		,CASE WHEN TP_OP = 0 THEN 'ESTADUAL'
		 WHEN TP_OP = 1 THEN 'INTERESTADUAL'
		 WHEN TP_OP = 2 THEN 'INTERNACIONAL'
		 ELSE 'NAO DEFINIDO'
		 END                                                                                                   AS TIPO_ORIGEM_DEST
		,EST_TRIB.CD_TRIB_FC
		,SUM(EST_NF_ENT_IT.VLR_IPI)                                                                            AS VLR_IPI
		,
		--CRIANDO O VALOR OUTROS
		CASE WHEN (EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT) = 0 OR EST_TRIB.ICMS = 1 THEN 
			CASE WHEN EST_TRIB.ICMS_RD = 1 AND ISNULL(PRC_FILIAL_CONFIG.VALOR,0)  = 0 THEN
				SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)-EST_NF_ENT_IT.VLR_BASE_ICMS)  
			ELSE
				0 
			END
		 ELSE CASE WHEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) > 0 THEN 
			SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) 
			ELSE 
				0 
			END 
		 END 
		 + 
		 CASE WHEN EST_TRIB.FLAG_OUTROS = 0 THEN 
				0 
			ELSE 
				CASE WHEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) > 0 THEN 
					SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC) ) 
				ELSE 
					0 
				END 
			END +
		 + SUM(EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS)
		 + SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS )
		 + ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_ST),0)  AS VLR_OUTRAS_DESPESAS


		,ISNULL(SUM(EST_NF_ENT_IT.VLR_ICMS_DESONERADO), 0)                                                     AS VLR_ICMS_DESONERADO
		,CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 PG_FORN,
																					 GLB_CID
																				 WHERE
																					PG_FORN.CD_EMP  = V_EST_NF_ENT_CAB.CD_EMP AND
																					PG_FORN.CD_FORN = V_EST_NF_ENT_CAB.CD_FORN AND
																					PG_FORN.CD_CID  = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 PRC_FILIAL,
																					 GLB_CID
																				 WHERE
																					PRC_FILIAL.CD_EMP    = V_EST_NF_ENT_CAB.CD_EMP AND
																					PRC_FILIAL.CD_FILIAL = V_EST_NF_ENT_CAB.CD_FORN AND
																					PRC_FILIAL.CD_CID    = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 RC_CLI,
																					 GLB_CID
																				 WHERE
																					RC_CLI.CD_EMP = V_EST_NF_ENT_CAB.CD_EMP AND
																					RC_CLI.CD_CLI = V_EST_NF_ENT_CAB.CD_FORN AND
																					RC_CLI.CD_CID = GLB_CID.CD_CID)
		 ELSE 'SEM CLASSIFICAO DESTINATARIO'
		 END                                                                                                   AS UF_DEST
		,GLB_CID.UF                                                                                            AS UF_FILIAL
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_ENT_IT.PERC_IVA
		,CASE WHEN EST_TRIB.ICMS = 0 THEN 'NO'
		 ELSE 'SIM'
		 END                                                                                                   AS ICMS_CRED_DEB
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_ICMS_RET), 0)                                                       AS VLR_BASE_ICMS_RET
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_ICMS_RET), 0)                                                            AS VLR_ICMS_RET
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_ICMS_OP), 0)                                                        AS VLR_BASE_ICMS_OP
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_ICMS_OP), 0)                                                             AS VLR_ICMS_OP
		,'NO'                                                                                                 AS SERVICO
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS_SUBS
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FRETE_IT), 0)					                                           AS VLR_PROD_FRETE
		,CASE WHEN V_EST_NF_ENT_CAB.FLAG_MOV_OP_NFE_CPL = 1 THEN 'SIM'
		 ELSE 'NO'
		 END																									AS NOTA_CPL
		,EST_NF_ENT_IT.VLR_PROD_PMC																				AS VLR_PMC
		
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_FECOP_ST),0)															AS VLR_BASE_FECOP_ST_IT
		,ISNULL(EST_NF_ENT_IT.PERC_FECOP_ST,0)																	AS PERC_FECOP_ST
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_ST),0)																AS VLR_FECOP_ST_IT
		
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_FECOP_RET),0)														AS VLR_BASE_FECOP_RET_IT
		,ISNULL(PERC_FECOP_RET,0) 																				AS PERC_FECOP_RET
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_RET),0) 															AS VLR_FECOP_RET_IT
		
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_FECOP),0)															AS VLR_BASE_FECOP_IT
		,ISNULL(EST_NF_ENT_IT.PERC_FECOP,0)																		AS PERC_FECOP
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP),0)																	AS VLR_FECOP_IT
		
		,V_EST_NF_ENT_CAB.CD_NF                                                                                 AS CD_NF
		,ISNULL(GLB_NT_OP.FLAG_NAO_GERA_GIA	,0)																	AS FLAG_NAO_GERA_GIA      
		,SUM(EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT)														AS VLR_BRUTO		
		,0 AS VLR_ICMS_DIFAL
		,0 AS BASE_ICMS_DIFAL
		-- Inicio Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
        
		,ISNULL(EST_NF_ENT_IT.CST_PIS,0)                AS  CST_PIS
        ,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_PIS),0)      AS  VLR_BASE_PIS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_PIS),0)           AS  VLR_PIS
		,ISNULL(EST_NF_ENT_IT.CST_COFINS,0)             AS  CST_COFINS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_COFINS),0)   AS  VLR_BASE_COFINS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_COFINS),0)        AS  VLR_COFINS
		,EST_PROD.NR_NCM
		,CASE WHEN ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) = 0 THEN   'SIM'    
          ELSE   'NAO'  
		  END                                           AS FLAG_NAO_GERAR_ARQ_SPED 
        
		,ISNULL(CASE WHEN EST_NF_ENT_IT.CST_PIS IN(4,5,6,7,8,9) THEN  
             EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA 
        ELSE 0 END,0) AS CD_NAT_RECEITA 
		
		,CASE WHEN EST_NF_ENT_IT.CST_PIS IN(4,5,6,7,8,9) THEN     
             'Sim'  
        ELSE 'No' END AS RECEITA_ISENTA 
		,CASE WHEN V_EST_NF_ENT_CAB.TP_SR_NFE = 0 THEN '' ELSE 'NFE' END AS TP_SR_NFE
		,'No' AS NOTA_CUPOM 
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_DESC),0)          AS  VLDESC
		,ISNULL(EST_NF_ENT_IT.PERC_ALIQ_PIS,0)          AS  PERC_ALIQ_PIS
		,ISNULL(EST_NF_ENT_IT.PERC_ALIQ_COFINS,0)       AS  PERC_ALIQ_COFINS
        ,0                                             AS PERC_RED_BASE_CALC_EFET 
        ,0                                             AS PERC_ICMS_EFET  
        ,0                                             AS PERC_ICMS_RET 
        ,0                                             AS PERC_ST 
        ,0                                             AS VLR_BASE_CALC_EFET 
        ,0                                             AS VLR_ICMS_EFET 
        ,0                                             AS  VLR_BASE_CALC_RET 
		,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END AS NOTA_SERVICO 
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN DT_EMI_NF ELSE NULL END AS DT_COMP

		-- Fim Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
		,ISNULL(V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)		AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,ISNULL(EST_NF_ENT_IT.CD_BENEF, '') AS CD_BENEF_IT
		,ISNULL(EST_NF_ENT_IT.CD_BENEF_RED, '') AS CD_BENEF_RED_IT
		,ISNULL(GLB_CID.UF,'') AS UF_FIL
		,ISNULL(GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS,0) AS FLAG_FECOP_NAO_APURA_ICMS
	FROM
		V_EST_NF_ENT_CAB   
		INNER JOIN EST_NF_ENT_IT ON
			V_EST_NF_ENT_CAB.CD_EMP = EST_NF_ENT_IT.CD_EMP AND
			V_EST_NF_ENT_CAB.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND
			V_EST_NF_ENT_CAB.CD_NF = EST_NF_ENT_IT.CD_NF
		INNER JOIN GLB_NT_OP ON
			EST_NF_ENT_IT.CD_NT_OP = GLB_NT_OP.CD_NT_OP
		INNER JOIN GLB_MOV_OP ON
			V_EST_NF_ENT_CAB.CD_MOV_OP = GLB_MOV_OP.CD_MOV_OP
		INNER JOIN EST_TRIB ON
			EST_NF_ENT_IT.CD_TRIB = EST_TRIB.CD_TRIB
		INNER JOIN PRC_FILIAL ON
			V_EST_NF_ENT_CAB.CD_EMP = PRC_FILIAL.CD_EMP AND
			V_EST_NF_ENT_CAB.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		INNER JOIN EST_PROD ON 
			EST_NF_ENT_IT.CD_EMP =  EST_PROD.CD_EMP 
			AND EST_NF_ENT_IT.CD_PROD =  EST_PROD.CD_PROD
	   LEFT JOIN EST_PROD_NCM_NATUREZA_RECEITA ON  
          EST_PROD.CD_EMP = EST_PROD_NCM_NATUREZA_RECEITA.CD_EMP AND  
          EST_PROD.CD_PROD = EST_PROD_NCM_NATUREZA_RECEITA.CD_PROD 
				 
		LEFT OUTER JOIN EST_NF_ENT_DAR_IT ON
			EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP AND
			EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL AND
			EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DAR_IT.CD_NF AND
			EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_DAR_IT.CD_PROD
		LEFT JOIN GLB_CID ON
			PRC_FILIAL.CD_CID = GLB_CID.CD_CID
		LEFT OUTER JOIN PRC_FILIAL_CONFIG   ON 
            PRC_FILIAL.CD_FILIAL = PRC_FILIAL_CONFIG.CD_FILIAL AND 
            PRC_FILIAL.CD_EMP  = PRC_FILIAL_CONFIG.CD_EMP  AND 
	    	PRC_FILIAL_CONFIG.CD_CHAVE = 'VALOR_REDUCAO_BASE_ICMS_EM_ISENTAS'  
	WHERE
		V_EST_NF_ENT_CAB.STS_NF = 0 AND
		EST_NF_ENT_DAR_IT.CD_NF IS NULL
	GROUP  BY
		EST_NF_ENT_IT.CD_EMP
		,EST_NF_ENT_IT.CD_FILIAL
		,GLB_NT_OP.CD_NT_OP_FC
		,TP_OP
		,EST_TRIB.CD_TRIB_FC
		,EST_TRIB.ICMS
		,EST_TRIB.SUBS_TRIB
		,EST_TRIB.SUBS_TRIB_ANT
		,EST_TRIB.ISENTO
		,EST_TRIB.FLAG_OUTROS
		,V_EST_NF_ENT_CAB.NR_NF
		,GLB_CID.UF
		,V_EST_NF_ENT_CAB.CD_EMP
		,V_EST_NF_ENT_CAB.CD_FORN
		,GLB_MOV_OP.DEST_ORIG
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_ENT_IT.ALIQ_ICMS
		,EST_NF_ENT_IT.PERC_IVA
		,EST_NF_ENT_IT.DT_ENT
		,EST_TRIB.ICMS
		,V_EST_NF_ENT_CAB.FLAG_NOTA_EMISSAO_PROPRIA
		,V_EST_NF_ENT_CAB.TP_MOV
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS_SUBS
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS
		,V_EST_NF_ENT_CAB.FLAG_MOV_OP_NFE_CPL
		,V_EST_NF_ENT_CAB.VLR_OUTROS
		,V_EST_NF_ENT_CAB.VLR_NF
		,EST_NF_ENT_IT.VLR_PROD_PMC
		,GLB_MOV_OP.TP_MOV
		,PRC_FILIAL.REGIME_TRIBUTARIO
		,EST_NF_ENT_IT.PERC_FECOP_ST
		,EST_NF_ENT_IT.PERC_FECOP_RET
		,EST_NF_ENT_IT.PERC_FECOP
		,V_EST_NF_ENT_CAB.CD_NF
		,EST_TRIB.ICMS_RD
		,GLB_NT_OP.FLAG_NAO_GERA_GIA
		,PRC_FILIAL_CONFIG.VALOR
		,EST_NF_ENT_IT.CST_PIS
		,EST_NF_ENT_IT.CST_COFINS
		,EST_PROD.NR_NCM
		,GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED
		,EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA
		,V_EST_NF_ENT_CAB.TP_SR_NFE
		,EST_NF_ENT_IT.PERC_ALIQ_PIS
		,EST_NF_ENT_IT.PERC_ALIQ_COFINS
		,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END 
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN DT_EMI_NF ELSE NULL END,
		V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,EST_NF_ENT_IT.CD_BENEF
		,EST_NF_ENT_IT.CD_BENEF_RED
		,ISNULL(GLB_CID.UF,'')
		,GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS

	UNION ALL
	SELECT
		EST_NF_ENT_IT.CD_EMP
		,EST_NF_ENT_IT.CD_FILIAL
		,V_EST_NF_ENT_CAB.DT_ENT
		,0                                                                                            AS CD_CX
		,V_EST_NF_ENT_CAB.NR_NF                                                                       AS NR_DOC
		,GLB_NT_OP.CD_NT_OP_FC                                                                        AS CFOP
		,SUM(ROUND(EST_NF_ENT_IT.VLR_IT *EST_NF_ENT_IT.QT_IT,2) - EST_NF_ENT_IT.VLR_DESC)
		 + SUM(EST_NF_ENT_IT.VLR_IPI)
		 + ISNULL(SUM(EST_NF_ENT_IT.VLR_FRETE_IT), 0)
		 + SUM(EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS) 
		 - SUM (CASE WHEN ISNULL(V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) = 0   THEN 0 ELSE -- CASE ADICIONADO
					 ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) END )AS VLR_CONTAB
		,
		CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1   THEN
			 0
		ELSE
			 CASE WHEN SUM(EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS) = 0 THEN
				CASE WHEN EST_TRIB.ICMS = 1 THEN SUM(EST_NF_ENT_IT.VLR_BASE_ICMS)
				WHEN V_EST_NF_ENT_CAB.FLAG_NOTA_EMISSAO_PROPRIA = 1  OR
							 V_EST_NF_ENT_CAB.TP_MOV = 11 THEN SUM(EST_NF_ENT_IT.VLR_BASE_ICMS)
				ELSE 0
				END
			 ELSE 0
			 END
		END AS VLR_BASE_ICMS

		,CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1    THEN
		     0
		ELSE
		    CASE WHEN SUM(EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS) = 0 THEN
				CASE WHEN EST_TRIB.ICMS = 1 THEN EST_NF_ENT_IT.ALIQ_ICMS
				WHEN V_EST_NF_ENT_CAB.FLAG_NOTA_EMISSAO_PROPRIA = 1  OR
						    V_EST_NF_ENT_CAB.TP_MOV = 11 THEN EST_NF_ENT_IT.ALIQ_ICMS
				ELSE 0
				END
			ELSE 0
			END                                                                                          
		 END AS ALIQ_ICMS

		,CASE WHEN ISNULL(PRC_FILIAL.REGIME_TRIBUTARIO,0) = 1   THEN
			 0
		 ELSE
		    CASE WHEN SUM(EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS) = 0 THEN
				CASE WHEN EST_TRIB.ICMS = 1 THEN SUM(EST_NF_ENT_IT.VLR_ICMS_IT)
				WHEN V_EST_NF_ENT_CAB.FLAG_NOTA_EMISSAO_PROPRIA = 1  OR
						    V_EST_NF_ENT_CAB.TP_MOV = 11 THEN SUM(EST_NF_ENT_IT.VLR_ICMS_IT)
				ELSE 0
				END
			ELSE 0
			END                                                                                          
		 END AS VLR_ICMS

		,CASE WHEN EST_TRIB.ICMS = 0 AND
					EST_TRIB.ISENTO = 0 THEN 0
		 ELSE
			 CASE WHEN EST_TRIB.ISENTO = 0 THEN
				 CASE WHEN ( EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT ) = 0 THEN
					 CASE WHEN SUM(( ROUND( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT ,2) - EST_NF_ENT_IT.VLR_DESC ) - EST_NF_ENT_IT.VLR_BASE_ICMS) > 0 THEN ROUND(SUM(( ( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT ) - ( EST_NF_ENT_IT.VLR_DESC
																																																																																																			 + ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) ) - EST_NF_ENT_IT.VLR_BASE_ICMS )), 2)
					 ELSE 0
					 END
				 ELSE 0
				 END
			 ELSE
				 CASE WHEN ( EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT ) = 0 THEN
					 CASE WHEN SUM(( ROUND( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT ,2) - EST_NF_ENT_IT.VLR_DESC )) > 0 THEN ROUND(SUM(( ( EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT ) - ( EST_NF_ENT_IT.VLR_DESC
																																																																																				 + ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) ) )), 2)
					 ELSE 0
					 END
				 ELSE 0
				 END
			 END
		 END                                                                                          AS VLR_ISENTO
		,0                                                                                            AS VLR_SERVICO
		,CASE WHEN EST_TRIB.SUBS_TRIB = 1 THEN SUM(EST_NF_ENT_IT.VLR_BASE_SUBS)
		 ELSE 0
		 END                                                                                          AS VLR_BASE_SUBS
		,CASE WHEN EST_TRIB.SUBS_TRIB = 1 THEN SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS)
		 ELSE 0
		 END                                                                                          AS VLR_ICMS_SUBS
		,SUM(EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS)                                                         AS VLR_ICMS_SUBS_DARE
		,'ENTRADA'                                                                                    AS TIPO
		,'DARE'                                                                                       AS TIPO_DOC
		,CASE WHEN TP_OP = 0 THEN 'ESTADUAL'
		 WHEN TP_OP = 1 THEN 'INTERESTADUAL'
		 WHEN TP_OP = 2 THEN 'INTERNACIONAL'
		 ELSE 'NAO DEFINIDO'
		 END                                                                                          AS TIPO_ORIGEM_DEST
		,EST_TRIB.CD_TRIB_FC
		,SUM(EST_NF_ENT_IT.VLR_IPI)                                                                   AS VLR_IPI
		,
		--'CRIANDO O VALOR OUTROS
		CASE WHEN (EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT) = 0 OR EST_TRIB.ICMS = 1 THEN 
			CASE WHEN EST_TRIB.ICMS_RD =1 THEN
				SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC))  - SUM(EST_NF_ENT_IT.VLR_BASE_ICMS)
			ELSE
				0 
			END		
		ELSE CASE WHEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) > 0 THEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) ELSE 0 END END + CASE WHEN EST_TRIB.FLAG_OUTROS = 0 THEN 0 ELSE CASE WHEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC)) > 0 THEN SUM((ROUND(EST_NF_ENT_IT.QT_IT*EST_NF_ENT_IT.VLR_IT,2) - EST_NF_ENT_IT.VLR_DESC) ) ELSE 0 END END
		 + SUM(EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS )
		 + SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS )  AS VLR_OUTRAS_DESPESAS
		
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_ICMS_DESONERADO), 0)                                            AS VLR_ICMS_DESONERADO
		,CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 PG_FORN,
																					 GLB_CID
																				 WHERE
																					PG_FORN.CD_EMP  = V_EST_NF_ENT_CAB.CD_EMP AND
																					PG_FORN.CD_FORN = V_EST_NF_ENT_CAB.CD_FORN AND
																					PG_FORN.CD_CID  = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 PRC_FILIAL,
																					 GLB_CID
																				 WHERE
																					PRC_FILIAL.CD_EMP    = V_EST_NF_ENT_CAB.CD_EMP AND
																					PRC_FILIAL.CD_FILIAL = V_EST_NF_ENT_CAB.CD_FORN AND
																					PRC_FILIAL.CD_CID    = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN (SELECT TOP 1
																					 UF
																				 FROM
																					 RC_CLI,
																					 GLB_CID
																				 WHERE
																					RC_CLI.CD_EMP = V_EST_NF_ENT_CAB.CD_EMP AND
																					RC_CLI.CD_CLI = V_EST_NF_ENT_CAB.CD_FORN AND
																					RC_CLI.CD_CID = GLB_CID.CD_CID)
		 ELSE 'SEM CLASSIFICAO DESTINATARIO'
		 END                                                                                          AS UF_DEST
		,GLB_CID.UF                                                                                   AS UF_FILIAL
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_ENT_IT.PERC_IVA
		,CASE WHEN EST_TRIB.ICMS = 0 THEN 'NO'
		 ELSE 'SIM'
		 END                                                                                          AS ICMS_CRED_DEB
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_ICMS_RET), 0)                                              AS VLR_BASE_ICMS_RET
		,CASE WHEN EST_TRIB.SUBS_TRIB = 1 AND
					V_EST_NF_ENT_CAB.TP_MOV = 0 THEN 0
		 ELSE SUM(EST_NF_ENT_IT.VLR_ICMS_SUBS)
		 END                                                                                          AS VLR_ICMS_RET
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_ICMS_OP), 0)                                               AS VLR_BASE_ICMS_OP
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_ICMS_OP), 0)                                                    AS VLR_ICMS_OP
		,'NO'                                                                                        AS SERVICO
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS_SUBS
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FRETE_IT), 0)                                                   AS VLR_PROD_FRETE
		,CASE WHEN V_EST_NF_ENT_CAB.FLAG_MOV_OP_NFE_CPL = 1 THEN 'SIM'
		 ELSE 'NO'
		 END                                                                                           AS NOTA_CPL
		,EST_NF_ENT_IT.VLR_PROD_PMC                                                                    AS VLR_PMC
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_FECOP_ST),0)                                                AS VLR_BASE_FECOP_ST_IT
		,ISNULL(EST_NF_ENT_IT.PERC_FECOP_ST,0)                                                         AS PERC_FECOP_ST
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_ST),0)                                                     AS VLR_FECOP_ST_IT
		,ISNULL(SUM(VLR_BASE_FECOP_RET),0)                                                             AS VLR_BASE_FECOP_RET_IT
		,ISNULL(PERC_FECOP_RET,0) 	                                                                   AS PERC_FECOP_RET
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP_RET),0) 	                                               AS VLR_FECOP_RET_IT
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_FECOP),0)												   AS VLR_BASE_FECOP_IT
		,ISNULL(EST_NF_ENT_IT.PERC_FECOP,0)															   AS PERC_FECOP
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_FECOP),0)														   AS VLR_FECOP_IT
		,V_EST_NF_ENT_CAB.CD_NF                                                                        AS CD_NF
		,ISNULL(GLB_NT_OP.FLAG_NAO_GERA_GIA,0)														   AS FLAG_NAO_GERA_GIA
		,SUM(EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT)		   									AS VLR_BRUTO		
		,0 AS VLR_ICMS_DIFAL
		,0 AS BASE_ICMS_DIFAL
		
		-- Inicio Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins

        ,ISNULL(EST_NF_ENT_IT.CST_PIS,0)              AS CST_PIS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_PIS),0)    AS VLR_BASE_PIS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_PIS),0)         AS VLR_PIS
		,ISNULL(EST_NF_ENT_IT.CST_COFINS,0)           AS CST_COFINS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_BASE_COFINS),0) AS VLR_BASE_COFINS
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_COFINS),0)      AS VLR_COFINS
		,EST_PROD.NR_NCM
		,CASE WHEN ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) = 0 THEN   
		     'Sim'    
         ELSE   
		     'No'  
		 END                                           AS FLAG_NAO_GERAR_ARQ_SPED 
	    
		,ISNULL(CASE WHEN EST_NF_ENT_IT.CST_PIS IN(4,5,6,7,8,9) THEN  
			EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA 
        ELSE 0 END,0)                                  AS CD_NAT_RECEITA 
       
	   ,CASE WHEN EST_NF_ENT_IT.CST_PIS IN(4,5,6,7,8,9) THEN     
             'Sim'  
        ELSE 'No' END AS RECEITA_ISENTA 
		,CASE WHEN V_EST_NF_ENT_CAB.TP_SR_NFE = 0 THEN '' ELSE 'NFE' END AS TP_SR_NFE 
        ,'No' AS NOTA_CUPOM 
		,ISNULL(SUM(EST_NF_ENT_IT.VLR_DESC),0)         AS  VLDESC
		,ISNULL(EST_NF_ENT_IT.PERC_ALIQ_PIS,0)         AS PERC_ALIQ_PIS
	    ,ISNULL(EST_NF_ENT_IT.PERC_ALIQ_COFINS,0)      AS  PERC_ALIQ_COFINS
        ,0                                             AS PERC_RED_BASE_CALC_EFET 
        ,0                                             AS PERC_ICMS_EFET  
        ,0                                             AS PERC_ICMS_RET 
        ,0                                             AS PERC_ST 
        ,0                                             AS VLR_BASE_CALC_EFET 
        ,0                                             AS VLR_ICMS_EFET 
        ,0                                             AS  VLR_BASE_CALC_RET 
        ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END AS NOTA_SERVICO 
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN DT_EMI_NF ELSE NULL END AS DT_COMP

		-- Fim Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
		,ISNULL(V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)		AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
	--'FIM
		,ISNULL(EST_NF_ENT_IT.CD_BENEF, '') AS CD_BENEF_IT
		,ISNULL(EST_NF_ENT_IT.CD_BENEF_RED, '') AS CD_BENEF_RED_IT
		,ISNULL(GLB_CID.UF,'') AS UF_FIL
		,ISNULL(GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS,0) AS FLAG_FECOP_NAO_APURA_ICMS
	FROM
		V_EST_NF_ENT_CAB
		INNER JOIN EST_NF_ENT_IT ON
			V_EST_NF_ENT_CAB.CD_EMP = EST_NF_ENT_IT.CD_EMP AND
			V_EST_NF_ENT_CAB.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND
			V_EST_NF_ENT_CAB.CD_NF = EST_NF_ENT_IT.CD_NF
		INNER JOIN GLB_MOV_OP ON
			V_EST_NF_ENT_CAB.CD_MOV_OP = GLB_MOV_OP.CD_MOV_OP
		INNER JOIN EST_NF_ENT_DAR_IT ON
			EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP AND
			EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL AND
			EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DAR_IT.CD_NF AND
			EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_DAR_IT.CD_PROD
		INNER JOIN GLB_NT_OP ON
			EST_NF_ENT_IT.CD_NT_OP = GLB_NT_OP.CD_NT_OP
		INNER JOIN EST_TRIB ON
			EST_NF_ENT_IT.CD_TRIB = EST_TRIB.CD_TRIB
		INNER JOIN PRC_FILIAL ON
			V_EST_NF_ENT_CAB.CD_EMP = PRC_FILIAL.CD_EMP AND
			V_EST_NF_ENT_CAB.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	   INNER JOIN EST_PROD ON 
			EST_NF_ENT_IT.CD_EMP =  EST_PROD.CD_EMP
			AND EST_NF_ENT_IT.CD_PROD =  EST_PROD.CD_PROD
	    LEFT JOIN EST_PROD_NCM_NATUREZA_RECEITA ON  
        EST_PROD.CD_EMP = EST_PROD_NCM_NATUREZA_RECEITA.CD_EMP AND  
        EST_PROD.CD_PROD = EST_PROD_NCM_NATUREZA_RECEITA.CD_PROD 
		LEFT JOIN GLB_CID ON
			PRC_FILIAL.CD_CID = GLB_CID.CD_CID
	WHERE
		STS_NF = 0
	GROUP  BY
		EST_NF_ENT_IT.CD_EMP
		,EST_NF_ENT_IT.CD_FILIAL
		,GLB_NT_OP.CD_NT_OP_FC
		,TP_OP
		,EST_TRIB.CD_TRIB_FC
		,EST_TRIB.ICMS
		,EST_TRIB.ISENTO
		,V_EST_NF_ENT_CAB.NR_NF
		,EST_TRIB.FLAG_OUTROS
		,EST_TRIB.SUBS_TRIB
		,EST_TRIB.SUBS_TRIB_ANT
		,GLB_CID.UF
		,V_EST_NF_ENT_CAB.CD_EMP
		,V_EST_NF_ENT_CAB.CD_FORN
		,GLB_MOV_OP.DEST_ORIG
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_ENT_IT.ALIQ_ICMS
		,EST_NF_ENT_IT.PERC_IVA
		,V_EST_NF_ENT_CAB.DT_ENT
		,EST_TRIB.ICMS
		,V_EST_NF_ENT_CAB.FLAG_NOTA_EMISSAO_PROPRIA
		,V_EST_NF_ENT_CAB.TP_MOV
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS_SUBS
		,V_EST_NF_ENT_CAB.GERA_MOV_ICMS
		,V_EST_NF_ENT_CAB.FLAG_MOV_OP_NFE_CPL
		,EST_NF_ENT_IT.VLR_PROD_PMC
		,PRC_FILIAL.REGIME_TRIBUTARIO
		,EST_NF_ENT_IT.PERC_FECOP_ST
		,EST_NF_ENT_IT.PERC_FECOP_RET
		,EST_NF_ENT_IT.PERC_FECOP
		,V_EST_NF_ENT_CAB.CD_NF
		,EST_TRIB.ICMS_RD
		,GLB_NT_OP.FLAG_NAO_GERA_GIA
        ,EST_NF_ENT_IT.CST_PIS 
		,EST_NF_ENT_IT.CST_COFINS
	    ,EST_PROD.NR_NCM
		,GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED
        ,EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA
		,V_EST_NF_ENT_CAB.TP_SR_NFE
		,EST_NF_ENT_IT.PERC_ALIQ_PIS
		,EST_NF_ENT_IT.PERC_ALIQ_COFINS
		,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN DT_EMI_NF ELSE NULL END
		,V_EST_NF_ENT_CAB.FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,EST_NF_ENT_IT.CD_BENEF
		,EST_NF_ENT_IT.CD_BENEF_RED
		,ISNULL(GLB_CID.UF,'')
		,ISNULL(GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS,0) 
	UNION ALL
	SELECT
		EST_NF_SAI.CD_EMP
		,EST_NF_SAI.CD_FILIAL
		,EST_NF_SAI.DT_EMI_NF                                                                                                                        DT_ENT
		,0                                                                                                                                           AS CD_CX
		,EST_NF_SAI.NF_NF                                                                                                                            AS NR_DOC
		,GLB_NT_OP.CD_NT_OP_FC                                                                                                                       AS CFOP
		,SUM((EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT) - EST_NF_SAI_IT.VLR_DESC_IT)
		 + SUM(EST_NF_SAI_IT.VLR_ICMS_SUBS)
		 + SUM(ROUND(ISNULL(((EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT) - DBO.EST_NF_SAI_IT.VLR_DESC_IT) * EST_NF_SAI_IT.PERC_IPI, 0)/100, 2))
		 + ISNULL(SUM(EST_NF_SAI_IT.VLR_PROD_FRETE), 0)
		 + ISNULL(SUM(EST_NF_SAI_IT.VLR_OUTROS_DESPESAS), 0) 
         + ISNULL(SUM(EST_NF_SAI_IT.VLR_FECOP_ST),0)
		- SUM(CASE WHEN ISNULL(V_GLB_PESSOA.FLAG_NAO_ABATER_ICMS_DESONERADO,0) = 1   THEN 0 ELSE --CASO ADICIONADO
					 ISNULL(EST_NF_SAI_IT.VLR_ICMS_DESONERADO, 0) END )      AS VLR_CONTAB
					 
		,CASE WHEN EST_TRIB.ICMS = 1 THEN
			CASE WHEN  GLB_CID.UF = 'PR' THEN
				SUM(EST_NF_SAI_IT.VLR_BASE_ICMS_IT)
			ELSE
				CASE WHEN ISNULL(PDV_VD_EST_NF_SAI.CD_NF, 0) = 0 THEN 
					SUM(EST_NF_SAI_IT.VLR_BASE_ICMS_IT)
				 ELSE 0
				 END
			END
		 WHEN EST_TRIB.SUBS_TRIB = 1 THEN 
			SUM(EST_NF_SAI_IT.VLR_BASE_ICMS_IT)
		 ELSE 
			0
		 END  AS VLR_BASE_ICMS

		,CASE WHEN EST_TRIB.ICMS = 1  OR EST_TRIB.SUBS_TRIB = 1 THEN
			 CASE WHEN  GLB_CID.UF = 'PR' THEN
				EST_NF_SAI_IT.ALIQ_ICMS
			 ELSE
				CASE WHEN ISNULL(PDV_VD_EST_NF_SAI.CD_NF, 0) = 0  THEN 
					EST_NF_SAI_IT.ALIQ_ICMS
				 ELSE 
					0
				 END
              END

		 ELSE 0
		 END
	
		,CASE WHEN EST_TRIB.ICMS = 1 THEN
			 CASE WHEN  GLB_CID.UF = 'PR' THEN
				SUM(EST_NF_SAI_IT.VLR_ICMS_IT)
			 ELSE

				 CASE WHEN ISNULL(PDV_VD_EST_NF_SAI.CD_NF, 0) = 0 THEN SUM(EST_NF_SAI_IT.VLR_ICMS_IT)
				 ELSE 0
				 END
			 END
		 WHEN EST_TRIB.SUBS_TRIB = 1 THEN 
			 SUM(EST_NF_SAI_IT.VLR_ICMS_IT)

		 WHEN  GLB_MOV_OP.TP_MOV = 58 THEN
			 SUM(EST_NF_SAI_IT.VLR_ICMS_IT)
		 ELSE 0
		 END  AS VLR_ICMS

		,CASE WHEN EST_TRIB.ISENTO = 1 THEN
			SUM(( ROUND(( EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT ) - EST_NF_SAI_IT.VLR_DESC_IT, 2) ))
		 ELSE
			 0
		 END
		  +  
		 CASE WHEN EST_TRIB.ICMS_RD = 1 and   ISNULL(PRC_FILIAL_CONFIG.VALOR,0)  = 1 THEN   
			SUM((ROUND(EST_NF_SAI_IT.QT_IT *EST_NF_SAI_IT.VLR_IT,2) - EST_NF_SAI_IT.VLR_DESC_IT)- EST_NF_SAI_IT.VLR_BASE_ICMS_IT )
		 ELSE
		     0
		 END 
				 
		  VLR_ISENTO
		,0                                                                                           AS VLR_SERVICO
		,
  
		CASE WHEN GLB_MOV_OP.TP_MOV = 11 AND
					ISNULL(EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD, 0) = 2 THEN ISNULL((SELECT TOP 1
								EST_NF_ENT_IT.VLR_BASE_SUBS
							FROM
								EST_NF_ENT_IT
								INNER JOIN EST_NF_ENT_NF_SAI ON
									EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_NF_SAI.CD_EMP AND
									EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_NF_SAI.CD_FILIAL AND
									EST_NF_ENT_IT.CD_NF = EST_NF_ENT_NF_SAI.CD_NF_ENT
								INNER JOIN EST_NF_SAI ON
									EST_NF_SAI.CD_EMP = EST_NF_ENT_NF_SAI.CD_EMP AND
									EST_NF_SAI.CD_FILIAL = EST_NF_ENT_NF_SAI.CD_FILIAL AND
									EST_NF_SAI.CD_NF = EST_NF_ENT_NF_SAI.CD_NF_SAI AND
									EST_NF_ENT_NF_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND
									EST_NF_ENT_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
									EST_NF_ENT_NF_SAI.CD_NF_SAI = EST_NF_SAI_IT.CD_NF AND
									EST_NF_ENT_IT.CD_PROD = EST_NF_SAI_IT.CD_PROD), 0)
		 ELSE SUM(EST_NF_SAI_IT.VLR_BASE_SUBS)
		 END                                                                                                                                         AS VLR_BASE_SUBS
		,CASE WHEN GLB_MOV_OP.TP_MOV = 11 AND
					ISNULL(EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD, 0) = 2 THEN ISNULL((SELECT TOP 1
																																					 EST_NF_ENT_IT.VLR_ICMS_SUBS
																																				 FROM
																																					 EST_NF_ENT_IT
																																					 INNER JOIN EST_NF_ENT_NF_SAI ON
																																						 EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_NF_SAI.CD_EMP AND
																																						 EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_NF_SAI.CD_FILIAL AND
																																						 EST_NF_ENT_IT.CD_NF = EST_NF_ENT_NF_SAI.CD_NF_ENT
																																					 INNER JOIN EST_NF_SAI ON
																																						 EST_NF_SAI.CD_EMP = EST_NF_ENT_NF_SAI.CD_EMP AND
																																						 EST_NF_SAI.CD_FILIAL = EST_NF_ENT_NF_SAI.CD_FILIAL AND
																																						 EST_NF_SAI.CD_NF = EST_NF_ENT_NF_SAI.CD_NF_SAI AND
																																						 EST_NF_ENT_NF_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND
																																						 EST_NF_ENT_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
																																						 EST_NF_ENT_NF_SAI.CD_NF_SAI = EST_NF_SAI_IT.CD_NF AND
																																						 EST_NF_ENT_IT.CD_PROD = EST_NF_SAI_IT.CD_PROD), 0)
		 ELSE SUM(EST_NF_SAI_IT.VLR_ICMS_SUBS)
		 END                                                                                                                                         AS VLR_ICMS_SUBS
		,0                                                                                                                                           AS VLR_ICMS_SUBS_DARE
		,'SAIDA'                                                                                                                                     AS TIPO
		,'NOTA FISCAL'                                                                                                                               AS TIPO_DOC
		,CASE WHEN TP_OP = 0 THEN 'ESTADUAL'
		 WHEN TP_OP = 1 THEN 'INTERESTADUAL'
		 WHEN TP_OP = 2 THEN 'INTERNACIONAL'
		 ELSE 'NAO DEFINIDO'
		 END                                                                                                                                         AS TIPO_ORIGEM_DEST
		,EST_TRIB.CD_TRIB_FC
		,SUM(ROUND(ISNULL(( ( EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT ) - DBO.EST_NF_SAI_IT.VLR_DESC_IT ) * EST_NF_SAI_IT.PERC_IPI, 0) / 100, 2)) AS VLR_IPI
		,
		--'CRIANDO O VALOR OUTROS
		--Em operaes de substituio tributria o Valor de Outras deve ser igual ao valor Contbil.
		--Em operaes provenientes de cupom fiscal o Valor de Outras deve ser igual ao valor Contbil.
		CASE WHEN PDV_VD_EST_NF_SAI.CD_EMP = 1 or (EST_TRIB.SUBS_TRIB + EST_TRIB.SUBS_TRIB_ANT) > 0 THEN
			 SUM((EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT) - EST_NF_SAI_IT.VLR_DESC_IT)
			 + SUM(EST_NF_SAI_IT.VLR_ICMS_SUBS)
			 + SUM(ROUND(ISNULL(((EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT) - DBO.EST_NF_SAI_IT.VLR_DESC_IT) * EST_NF_SAI_IT.PERC_IPI, 0)/100, 2))
			 + ISNULL(SUM(EST_NF_SAI_IT.VLR_PROD_FRETE), 0)
			 + ISNULL(SUM(EST_NF_SAI_IT.VLR_OUTROS_DESPESAS), 0) 
			 + ISNULL(SUM(EST_NF_SAI_IT.VLR_FECOP_ST),0)
			 - SUM(CASE WHEN ISNULL(V_GLB_PESSOA.FLAG_NAO_ABATER_ICMS_DESONERADO,0) = 1   THEN 0 ELSE ISNULL(EST_NF_SAI_IT.VLR_ICMS_DESONERADO, 0) END ) 	 	
		ELSE
			 
			CASE WHEN EST_TRIB.ICMS_RD =1 AND  ISNULL(PRC_FILIAL_CONFIG.VALOR,0)  = 0 THEN
				SUM((ROUND(EST_NF_SAI_IT.QT_IT *EST_NF_SAI_IT.VLR_IT,2) - EST_NF_SAI_IT.VLR_DESC_IT)- EST_NF_SAI_IT.VLR_BASE_ICMS_IT )  
			ELSE
				0 
			END
		 END AS VLR_OUTRAS_DESPESAS

		,ISNULL(SUM(EST_NF_SAI_IT.VLR_ICMS_DESONERADO), 0)                                                                                           AS VLR_ICMS_DESONERADO
		,CASE WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN (SELECT TOP 1
																UF
															FROM
																RC_CLI,
																GLB_CID
															WHERE
															 RC_CLI.CD_EMP = EST_NF_SAI.CD_EMP AND
															 RC_CLI.CD_CLI = EST_NF_SAI.CD_CLI AND
															 RC_CLI.CD_CID = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN (SELECT TOP 1
																UF
															FROM
																PG_FORN,
																GLB_CID
															WHERE
															 PG_FORN.CD_EMP  = EST_NF_SAI.CD_EMP AND
															 PG_FORN.CD_FORN = EST_NF_SAI.CD_CLI AND
															 PG_FORN.CD_CID  = GLB_CID.CD_CID)
		 WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN (SELECT TOP 1
																UF
															FROM
																PRC_FILIAL,
																GLB_CID
															WHERE
															 PRC_FILIAL.CD_EMP    = EST_NF_SAI.CD_EMP AND
															 PRC_FILIAL.CD_FILIAL = EST_NF_SAI.CD_CLI AND
															 PRC_FILIAL.CD_CID    = GLB_CID.CD_CID)
		 ELSE 'DESTINATRIO SEM CLASSIFICAO, SOLICITE AO DEPTO DE INFORMATICA A CLASSIFICAO DO MESMO'
		 END                                                                                                                                         AS UF_DEST
		,GLB_CID.UF                                                                                                                                  AS UF_FILIAL
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_SAI_IT.PERC_IVA
		,CASE WHEN EST_TRIB.ICMS = 0 THEN 'NO'
		 ELSE 'SIM'
		 END                                                                                                                                         AS ICMS_CRED_DEB
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_ICMS_RET), 0)                                                                                             AS VLR_BASE_ICMS_RET
		,SUM(EST_NF_SAI_IT.VLR_ICMS_RET)                                                                                                            AS VLR_ICMS_RET
		,0                                                                                                                                           AS VLR_BASE_ICMS_OP
		,0                                                                                                                                           AS VLR_ICMS_OP
		,'NO'                                                                                                                                       AS SERVICO
		,CASE WHEN GLB_MOV_OP.GERA_ICMS_SUBS = 0 THEN 'SIM'
		 ELSE 'NAO'
		 END                                                                                                                                         AS GERA_MOV_ICMS_SUBS
		,CASE WHEN GLB_MOV_OP.ALQ_ICMS = 0 THEN 'SIM'
		 ELSE 'NAO'
		 END                                                                                                                                         AS GERA_MOV_ICMS
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_PROD_FRETE), 0)                                                                                                AS VLR_PROD_FRETE
		,CASE WHEN GLB_MOV_OP.FLAG_MOV_OP_NFE_CPL = 1 THEN 'SIM'
		 ELSE 'NO'
		 END                                                                                                                                         AS NOTA_CPL
		,EST_NF_SAI_IT.VLR_PMC
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_FECOP_ST),0)                                                             AS VLR_BASE_FECOP_ST_IT
		,ISNULL(EST_NF_SAI_IT.PERC_FECOP_ST ,0)                                                                     AS PERC_FECOP_ST
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_FECOP_ST),0)                                                                  AS VLR_FECOP_ST_IT
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_FECOP_RET),0)                                                            AS VLR_BASE_FECOP_RET_IT
		,ISNULL(EST_NF_SAI_IT.PERC_FECOP_RET,0) 	                                                               AS PERC_FECOP_RET
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_FECOP_RET),0) 	                                                               AS VLR_FECOP_RET_IT
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_FECOP),0)															AS VLR_BASE_FECOP_IT
		,ISNULL(EST_NF_SAI_IT.PERC_FECOP,0)																		AS PERC_FECOP
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_FECOP),0)																	AS VLR_FECOP_IT
		,EST_NF_SAI.CD_NF
		,ISNULL(GLB_NT_OP.FLAG_NAO_GERA_GIA,0)                                                                  AS FLAG_NAO_GERA_GIA
		,SUM(EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_IT)														AS VLR_BRUTO
		,ISNULL(EST_NF_SAI_IT.VALOR_ICMS_DESTINO_DIFAL,0) AS VLR_ICMS_DIFAL
		,ISNULL(EST_NF_SAI_IT.BASE_ICMS_DESTINO_DIFAL,0) AS BASE_ICMS_DIFAL
		
		-- Inicio Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
        ,ISNULL(EST_NF_SAI_IT.CST_PIS,0)               AS CST_PIS  
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_PIS),0)     AS VLR_BASE_PIS  
	    ,ISNULL(SUM(EST_NF_SAI_IT.VLR_PIS),0)          AS VLR_PIS  
		,ISNULL(EST_NF_SAI_IT.CST_COFINS,0)            AS CST_COFINS 
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_COFINS),0)  AS VLR_BASE_COFINS
        ,ISNULL(SUM(EST_NF_SAI_IT.VLR_COFINS),0)       AS VLR_COFINS 
        ,EST_PROD.NR_NCM
        ,CASE WHEN ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) = 0 THEN   
			  'Sim'    
          ELSE   
		      'No'  
		  END                                           AS FLAG_NAO_GERAR_ARQ_SPED  
	    ,ISNULL(CASE WHEN EST_NF_SAI_IT.CST_PIS IN(4,5,6,7,8,9) THEN  
             EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA 
        ELSE 0 END,0) AS CD_NAT_RECEITA

		,CASE WHEN EST_NF_SAI_IT.CST_PIS IN(4,5,6,7,8,9) THEN     
             'Sim'  
        ELSE 
			'No' 
		END AS RECEITA_ISENTA
		,CASE WHEN EST_NF_SERIE.TP_SR_NFE = 0 THEN '' ELSE 'NFE' END AS TP_SR_NFE
		,CASE WHEN  GLB_MOV_OP.TP_MOV = 28  THEN   
		   'Sim'
		ELSE
			'No'
		END  AS NOTA_CUPOM 
		,ISNULL(SUM(EST_NF_SAI_IT.VLR_DESC_IT),0)      AS  VLDESC 
		,ISNULL(EST_NF_SAI_IT.PERC_ALIQ_PIS,0)         AS PERC_ALIQ_PIS 
		,ISNULL(EST_NF_SAI_IT.PERC_ALIQ_COFINS,0)      AS PERC_ALIQ_COFINS
	    ,0                                             AS PERC_RED_BASE_CALC_EFET 
        ,0                                             AS PERC_ICMS_EFET  
        ,0                                             AS PERC_ICMS_RET 
        ,0                                             AS PERC_ST 
        ,0                                             AS VLR_BASE_CALC_EFET 
        ,0                                             AS VLR_ICMS_EFET 
        ,0                                             AS  VLR_BASE_CALC_RET 
		,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END AS NOTA_SERVICO 
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN EST_NF_SAI.DT_EMI_NF ELSE NULL END AS DT_COMP

		-- Fim Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
		,ISNULL(EST_NF_SAI.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)		AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,ISNULL(EST_NF_SAI_IT.CD_BENEF, '') AS CD_BENEF_IT
		,ISNULL(EST_NF_SAI_IT.CD_BENEF_RED, '') AS CD_BENEF_RED_IT
		,ISNULL(GLB_CID.UF,'') AS UF_FIL
		,ISNULL(GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS,0) AS FLAG_FECOP_NAO_APURA_ICMS
	FROM
		EST_NF_SAI
		INNER JOIN EST_NF_SAI_IT ON
			EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP AND
			EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
			EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
		INNER JOIN GLB_NT_OP ON
			EST_NF_SAI_IT.CD_NT_OP = GLB_NT_OP.CD_NT_OP
		INNER JOIN GLB_MOV_OP ON
			EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
		INNER JOIN EST_TRIB ON
			EST_NF_SAI_IT.CD_TRIB = EST_TRIB.CD_TRIB
		INNER JOIN PRC_FILIAL ON
			EST_NF_SAI.CD_EMP = PRC_FILIAL.CD_EMP AND
			EST_NF_SAI.CD_FILIAL = PRC_FILIAL.CD_FILIAL
      INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
									AND DBO.EST_NF_SAI.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE
	   INNER JOIN EST_PROD ON 
			EST_NF_SAI_IT.CD_EMP =  EST_PROD.CD_EMP
			AND EST_NF_SAI_IT.CD_PROD =  EST_PROD.CD_PROD
	    LEFT JOIN EST_PROD_NCM_NATUREZA_RECEITA ON  
        EST_PROD.CD_EMP = EST_PROD_NCM_NATUREZA_RECEITA.CD_EMP AND  
        EST_PROD.CD_PROD = EST_PROD_NCM_NATUREZA_RECEITA.CD_PROD	
			    
		LEFT OUTER JOIN PDV_VD_EST_NF_SAI ON
			EST_NF_SAI.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND
			EST_NF_SAI.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND
			EST_NF_SAI.CD_NF = PDV_VD_EST_NF_SAI.CD_NF
		LEFT JOIN GLB_CID ON
			PRC_FILIAL.CD_CID = GLB_CID.CD_CID
		OUTER APPLY UFD_GLB_PESSOA (EST_NF_SAI.CD_CLI, GLB_MOV_OP.DEST_ORIG)V_GLB_PESSOA
		LEFT OUTER JOIN PRC_FILIAL_CONFIG   ON 
            PRC_FILIAL.CD_FILIAL = PRC_FILIAL_CONFIG.CD_FILIAL AND 
            PRC_FILIAL.CD_EMP  = PRC_FILIAL_CONFIG.CD_EMP  AND 
         	PRC_FILIAL_CONFIG.CD_CHAVE = 'VALOR_REDUCAO_BASE_ICMS_EM_ISENTAS' 
	WHERE
		STS_NF = 0

	GROUP  BY
		EST_NF_SAI.CD_EMP
		,EST_NF_SAI.CD_FILIAL
		,PDV_VD_EST_NF_SAI.CD_EMP
		,GLB_NT_OP.CD_NT_OP_FC
		,TP_OP
		,EST_TRIB.CD_TRIB_FC
		,EST_TRIB.ICMS
		,PDV_VD_EST_NF_SAI.CD_NF
		,EST_TRIB.ICMS
		,EST_TRIB.ISENTO
		,EST_NF_SAI.NF_NF
		,EST_TRIB.SUBS_TRIB
		,EST_TRIB.SUBS_TRIB_ANT
		,EST_TRIB.FLAG_OUTROS
		,GLB_CID.UF
		,EST_NF_SAI.CD_EMP
		,EST_NF_SAI.CD_CLI
		,GLB_MOV_OP.DEST_ORIG
		,GLB_MOV_OP.DS_MOV_OP
		,EST_NF_SAI_IT.ALIQ_ICMS
		,EST_NF_SAI_IT.PERC_IVA
		,EST_NF_SAI.DT_EMI_NF
		,EST_NF_SAI_IT.VLR_PMC
		,EST_TRIB.ICMS
		,GLB_MOV_OP.GERA_ICMS_SUBS
		,GLB_MOV_OP.ALQ_ICMS
		,GLB_MOV_OP.FLAG_MOV_OP_NFE_CPL
		,GLB_MOV_OP.TP_MOV
		,EST_NF_SAI_IT.CD_FILIAL
		,EST_NF_SAI_IT.CD_NF
		,EST_NF_SAI_IT.CD_PROD
		,EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD
		,EST_NF_SAI_IT.PERC_FECOP_ST
		,EST_NF_SAI_IT.PERC_FECOP_RET
		,EST_NF_SAI_IT.PERC_FECOP
		,EST_NF_SAI.CD_NF
		,EST_TRIB.ICMS_RD
		,GLB_NT_OP.FLAG_NAO_GERA_GIA
		,PRC_FILIAL_CONFIG.VALOR
		,EST_NF_SAI_IT.VALOR_ICMS_DESTINO_DIFAL
		,EST_NF_SAI_IT.BASE_ICMS_DESTINO_DIFAL
		,EST_NF_SAI_IT.CST_PIS
		,EST_NF_SAI_IT.CST_COFINS
	    ,EST_PROD.NR_NCM
		,GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED
        ,EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA
		,EST_NF_SERIE.TP_SR_NFE
		,EST_NF_SAI_IT.PERC_ALIQ_PIS
        ,EST_NF_SAI_IT.PERC_ALIQ_COFINS
		,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN 'SIM' ELSE 'NO' END
	    ,CASE WHEN GLB_MOV_OP.TP_MOV = 32 THEN EST_NF_SAI.DT_EMI_NF ELSE NULL END
		,EST_NF_SAI.FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,EST_NF_SAI_IT.CD_BENEF
		,EST_NF_SAI_IT.CD_BENEF_RED
		,ISNULL(GLB_CID.UF,'')
		,ISNULL(GLB_NT_OP.FLAG_FECOP_NAO_APURA_ICMS,0)  
	UNION ALL
SELECT  
		CD_EMP
		, CD_FILIAL
		, DT_ENT
		, CD_CX
		, NR_DOC
		,CFOP
		,SUM(VLR_CONTAB)   AS VLR_CONTAB
		,SUM(VLR_BASE_ICMS)VLR_BASE_ICMS
		,ALIQ_ICMS
		,SUM(VLR_ICMS)     VLR_ICMS
		,SUM(VLR_ISENTO)   VLR_ISENTO
		,SUM(VLR_SERVICO)  VLR_SERVICO
		,0                 AS VLR_BASE_ICMS_SUBS
		,SUM(VLR_ICMS_SUBS)VLR_ICMS_SUBS
		,VLR_ICMS_SUBS_DARE
		,TIPO
		,TIPO_DOC
		,TIPO_ORIGEM_DEST
		,CD_TRIB_FC
		,VLR_IPI
		,SUM(VLR_OUTROS)   VLR_OUTRAS_DESPESAS
		,TEMP.VLR_ICMS_DESONERADO                 AS VLR_ICMS_DESONERADO
		,UF_DEST
		,UF_FILIAL
		,DS_MOV_OP
		,PERC_IVA
		,ICMS_CRED_DEB
		,0                 AS VLR_BASE_ICMS_RET
		,SUM(VLR_ICMS_RET) AS VLR_ICMS_RET
		,0                 AS VLR_BASE_ICMS_OP
		,0                 AS VLR_ICMS_OP
		,SERVICO
		,TIPO_DOC     AS GERA_MOV_ICMS_SUBS
		,TIPO_DOC     AS GERA_MOV_ICMS
		,SUM(VLR_PROD_FRETE)			AS VLR_PROD_FRETE
		,'NO'             				AS NOTA_CPL
		,SUM(VLR_PMC )                       AS VLR_PMC
		
		,SUM(VLR_BASE_FECOP_ST_IT)           AS VLR_BASE_FECOP_ST_IT
		,SUM(VLR_FECOP_ST_IT)                AS VLR_FECOP_ST_IT
		,PERC_FECOP_ST                AS PERC_FECOP_ST
		
		,SUM(VLR_BASE_FECOP_RET_IT)          AS VLR_BASE_FECOP_RET_IT
		,PERC_FECOP_RET                 AS PERC_FECOP_RET
		,SUM(VLR_FECOP_RET_IT )              AS VLR_FECOP_RET_IT
		
		,SUM(VLR_BASE_FECOP_IT	)			AS VLR_BASE_FECOP_IT
		,PERC_FECOP			            AS PERC_FECOP
		,SUM(VLR_FECOP_IT)		            AS VLR_FECOP_IT
		
		,0								AS CD_NF
		,0								AS FLAG_NAO_GERA_GIA
		,SUM(VLR_BRUTO)					AS VLR_BRUTO
		,0 AS VLR_ICMS_DIFAL
		,0 AS BASE_ICMS_DIFAL
		
		-- Inicio Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
        
		,CST_PIS
		,SUM(VLR_BASE_PIS)                    AS VLR_BASE_PIS
		,SUM(VLR_PIS)                         AS VLR_PIS
		,CST_COFINS				             
		,SUM(VLR_BASE_COFINS)                 AS VLR_BASE_COFINS
		,SUM(VLR_COFINS)                      AS VLR_COFINS
		,NR_NCM
		,FLAG_NAO_GERAR_ARQ_SPED 
		,CD_NAT_RECEITA
		,RECEITA_ISENTA
		,TP_SR_NFE
		,NOTA_CUPOM
		,VLDESC 
		,PERC_ALIQ_PIS
		,PERC_ALIQ_COFINS
		,PERC_RED_BASE_CALC_EFET        
		,PERC_ICMS_EFET              
		,PERC_ICMS_RET                   
		,PERC_ST                    
		,SUM(VLR_BASE_CALC_EFET)            AS VLR_BASE_CALC_EFET 
		,SUM(VLR_ICMS_EFET)                 AS VLR_ICMS_EFET 
		,SUM(VLR_BASE_CALC_RET)             AS VLR_BASE_CALC_RET 
		,NOTA_SERVICO 
	    ,DT_COMP
		-- Fim Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
		,ISNULL(TEMP.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)		AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,CD_BENEF_IT
		,CD_BENEF_RED_IT	
		, UF_FIL
		, FLAG_FECOP_NAO_APURA_ICMS
	FROM
		(SELECT  
			  PDV_VD.CD_EMP
			 ,PDV_VD.CD_FILIAL
			 ,PDV_VD.DT_VD                                                                         AS DT_ENT
			 ,PDV_VD.CD_CX
			 ,NR_ECF                                                                        AS NR_DOC
			 , CASE 
					 WHEN PRC_FILIAL.REGIME_TRIBUTARIO = 1  THEN 
					   CASE 
						 WHEN PDV_VD_IT.CD_TRIB_FC = '500' THEN '5.405' 
						 ELSE '5.102' 
					   END 
					 ELSE ( CASE 
							  WHEN PDV_VD_IT.TIPO_IMPOSTO = 0 THEN 
								CASE 
								  WHEN RIGHT(PDV_VD_IT.CD_TRIB_FC, 2) = '10' 
										OR RIGHT(PDV_VD_IT.CD_TRIB_FC, 2) = '60' 
										OR RIGHT(PDV_VD_IT.CD_TRIB_FC, 2) = '70' THEN 
								  '5.405' 
								  ELSE '5.102' 
								END 
							  ELSE '5.933' 
							END ) 
              END                                                 AS CFOP 
			 ,PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT       AS VLR_CONTAB
			
			,CASE WHEN TIPO_IMPOSTO = 0 THEN
					CASE WHEN PRC_FILIAL.REGIME_TRIBUTARIO = 1  AND LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2))='500' THEN
						0
					ELSE
						CASE WHEN LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2)) IN ('00','20','02') THEN 
							( PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT ) 
						ELSE 0
						END
					END
				ELSE
					0
				END                                           AS VLR_BASE_ICMS

			 ,	CASE WHEN LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2)) IN  ('40','03')  THEN ( PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT ) 
					ELSE 0
					END                                      AS VLR_ISENTO
			 , PDV_VD_IT.TX_ICMS_IT                     AS ALIQ_ICMS
			 ,

			 CASE WHEN ISNULL(PDV_VD_IT.VLR_ICMS,0) > 0 THEN 
				ROUND(PDV_VD_IT.VLR_ICMS , 2)
			 ELSE
				CASE WHEN PRC_FILIAL.REGIME_TRIBUTARIO = 1 AND PDV_VD_IT.CD_TRIB_FC='500' THEN
						0
					ELSE
						CASE WHEN LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2)) IN ('00','20','02') THEN
							CASE WHEN LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2)) = '00' THEN 
							ROUND(( PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT ) * ( PDV_VD_IT.TX_ICMS_IT / 100.0000 ) ,2)
							ELSE 
							ROUND(( ( PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT ) * ( PDV_VD_IT.TX_RED_IT / 100.0000 ) ) * ( PDV_VD_IT.TX_ICMS_IT / 100.0000 ),2)
			
							END
						ELSE 0 END
		 
					END  
			  END AS VLR_ICMS

             , CASE WHEN ISNULL(TIPO_IMPOSTO, 0) = 1 THEN 
							( PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT ) * ( PDV_VD_IT.TX_ICMS_IT / 100.0000 )
					 ELSE 0  END AS VLR_SERVICO
			 ,0                                                                              AS VLR_ICMS_SUBS
			 ,0                                                                              AS VLR_ICMS_SUBS_DARE
			 ,'SAIDA'                                                                        AS TIPO
			 ,CASE WHEN ISNULL(FLAG_NFCE,0) = 0  THEN 'CUPOM FISCAL' ELSE  'NOTA NFCE' END   AS TIPO_DOC
			 ,'ESTADUAL'                                                                     AS TIPO_ORIGEM_DEST
			 ,PDV_VD_IT.CD_TRIB_FC                                                           AS CD_TRIB_FC
			 ,0                                                                              AS VLR_IPI
			 , CASE WHEN LTRIM(RIGHT(PDV_VD_IT.CD_TRIB_FC, 2)) IN( '41','90','60')  THEN 
			 ( PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT ) 
					ELSE 0
					END                                                                      AS VLR_OUTROS
			 ,GLB_CID.UF                                                                     AS UF_DEST
			 ,GLB_CID.UF                                                                     AS UF_FILIAL
 
			 ,'CUPOM FISCAL'                                                                 AS DS_MOV_OP
			 ,0                                                                              AS PERC_IVA
			 ,'SIM'                                                                          AS ICMS_CRED_DEB
			 ,'NO'                                                                          AS SERVICO
		,ISNULL(PDV_VD_IT.VLR_FRETE_RAT,0)              AS VLR_PROD_FRETE
		,ISNULL(PDV_VD_IT.VLR_PMC,0)                    AS VLR_PMC
		
		,CASE WHEN ISNULL(PDV_VD_IT.VLR_FECOP_ST,0) > 0  THEN ISNULL(PDV_VD_IT.VLR_BASE_SUBST,0) ELSE 0 END AS VLR_BASE_FECOP_ST_IT
		,ISNULL(PDV_VD_IT.PERC_FECOP_ST,0)              AS PERC_FECOP_ST
		,ISNULL(PDV_VD_IT.VLR_FECOP_ST,0)               AS VLR_FECOP_ST_IT
		
		,CASE WHEN ISNULL(PDV_VD_IT.VLR_FECOP_RET,0) > 0 THEN ISNULL(PDV_VD_IT.VLR_BASE_CALC_RET,0) ELSE 0 END AS VLR_BASE_FECOP_RET_IT
		,ISNULL(PDV_VD_IT.PERC_FECOP_RET,0)             AS PERC_FECOP_RET
		,ISNULL(PDV_VD_IT.VLR_FECOP_RET,0)              AS VLR_FECOP_RET_IT
		
		,CASE WHEN ISNULL(PDV_VD_IT.VLR_FECOP,0)> 0  THEN ISNULL(PDV_VD_IT.VLR_BASE_CALC,0)	ELSE 0  END AS VLR_BASE_FECOP_IT
		,ISNULL(PDV_VD_IT.PERC_FECOP,0)					AS PERC_FECOP
		,ISNULL(PDV_VD_IT.VLR_FECOP,0)					AS VLR_FECOP_IT
		,ISNULL((PDV_VD_IT.QT_IT * PDV_VD_IT.VLR_IT),0)	AS VLR_BRUTO

		-- Inicio Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
       
	    ,ISNULL(PDV_VD_IT.CST_PIS,0)          AS CST_PIS 
		,ISNULL(PDV_VD_IT.VLR_BASE_PIS,0)     AS VLR_BASE_PIS
		,ISNULL(PDV_VD_IT.VLR_PIS,0)          AS VLR_PIS
        ,ISNULL(PDV_VD_IT.CST_COFINS,0)       AS CST_COFINS
		,ISNULL(PDV_VD_IT.VLR_BASE_COFINS,0)  AS VLR_BASE_COFINS
		,ISNULL(PDV_VD_IT.VLR_COFINS,0)       AS VLR_COFINS
		,EST_PROD.NR_NCM
		,'Sim'                                AS FLAG_NAO_GERAR_ARQ_SPED 
		,ISNULL(CASE WHEN PDV_VD_IT.CST_PIS IN(4,5,6,7,8,9) THEN  
             EST_PROD_NCM_NATUREZA_RECEITA.CD_NAT_RECEITA 
        ELSE 0 END,0) AS CD_NAT_RECEITA
        
		,CASE WHEN PDV_VD_IT.CST_PIS IN(4,5,6,7,8,9) THEN     
              'Sim'  
         ELSE 'No' END AS RECEITA_ISENTA
		 ,'CUPOM' AS TP_SR_NFE
		 , 'No'  NOTA_CUPOM
		 ,0                                        AS  VLDESC 
		 ,ISNULL(PDV_VD_IT.PERC_ALIQ_PIS,0)        AS PERC_ALIQ_PIS
		 ,ISNULL(PDV_VD_IT.PERC_ALIQ_COFINS,0)     AS PERC_ALIQ_COFINS
		 ,ISNULL(PERC_RED_BASE_CALC_EFET,0)        AS PERC_RED_BASE_CALC_EFET 
		 ,ISNULL(PERC_ICMS_EFET ,0)                AS PERC_ICMS_EFET 
		 ,ISNULL(PERC_ICMS_RET ,0)                 AS PERC_ICMS_RET 
		 ,ISNULL(PERC_ST ,0)                       AS PERC_ST 
		 ,ISNULL(PDV_VD_IT.VLR_BASE_CALC_EFET ,0)            AS VLR_BASE_CALC_EFET 
		 ,ISNULL(PDV_VD_IT.VLR_ICMS_EFET ,0)                 AS VLR_ICMS_EFET 
		 ,ISNULL(PDV_VD_IT.VLR_BASE_CALC_RET ,0)             AS VLR_BASE_CALC_RET
		 ,ISNULL( PDV_VD_IT.VLR_ICMS_RET ,0)                 AS VLR_ICMS_RET  
	   	 ,CASE WHEN ISNULL(EST_RPS.CD_EMP,'') <> '' THEN 'SIM' ELSE 'NO' END AS NOTA_SERVICO 
	     ,CASE WHEN ISNULL(EST_RPS.CD_EMP,'') <> '' THEN EST_RPS.DT_COMP ELSE NULL END AS DT_COMP,  		 
		-- Fim Campos acrescentados para atender Relatrio de Analise CFOP Pis/Cofins
		 ISNULL(PDV_VD.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)		AS FLAG_VLR_ICMS_DESONERADO_DESCONTO,
		 ISNULL(PDV_VD_IT.VLR_ICMS_DESONERADO_IT,0) as VLR_ICMS_DESONERADO
		,ISNULL(CONVERT(VARCHAR,PDV_VD_IT.CD_BENEF), '') AS CD_BENEF_IT
		,ISNULL(PDV_VD_IT.CD_BENEF_RED, '') AS CD_BENEF_RED_IT
		,ISNULL(GLB_CID.UF,'') AS UF_FIL
		, 0 AS FLAG_FECOP_NAO_APURA_ICMS
		FROM    PDV_VD_IT
					JOIN PDV_VD ON
						PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
						PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
						PDV_VD.CD_VD  = PDV_VD_IT.CD_VD  
				LEFT JOIN PDV_VD_IT_EST_RPS ON PDV_VD_IT.CD_EMP = PDV_VD_IT_EST_RPS.CD_EMP
												AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_EST_RPS.CD_FILIAL
												AND PDV_VD_IT.CD_VD = PDV_VD_IT_EST_RPS.CD_VD
												AND PDV_VD_IT.CD_IT = PDV_VD_IT_EST_RPS.CD_IT
				LEFT JOIN EST_RPS_IT ON EST_RPS_IT.CD_EMP = PDV_VD_IT_EST_RPS.CD_EMP
												AND EST_RPS_IT.CD_FILIAL = PDV_VD_IT_EST_RPS.CD_FILIAL
												AND EST_RPS_IT.RPS_ID = PDV_VD_IT_EST_RPS.ID
				LEFT JOIN EST_RPS ON EST_RPS.CD_EMP = EST_RPS_IT.CD_EMP
												AND EST_RPS.CD_FILIAL = EST_RPS_IT.CD_FILIAL
												AND EST_RPS.ID = EST_RPS_IT.RPS_ID
				INNER JOIN PRC_FILIAL ON
				PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP AND
				PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	            INNER JOIN EST_PROD ON 
			       PDV_VD_IT.CD_EMP =  EST_PROD.CD_EMP
				   AND PDV_VD_IT.CD_PROD =  EST_PROD.CD_PROD
				LEFT JOIN EST_PROD_NCM_NATUREZA_RECEITA ON  
					EST_PROD.CD_EMP = EST_PROD_NCM_NATUREZA_RECEITA.CD_EMP AND  
					EST_PROD.CD_PROD = EST_PROD_NCM_NATUREZA_RECEITA.CD_PROD
				   
				LEFT JOIN GLB_CID ON
		        PRC_FILIAL.CD_CID = GLB_CID.CD_CID
				 
		 WHERE
				PDV_VD.ST_VD   = 0 AND
				PDV_VD_IT.ST_IT = 1
			 
			 ) TEMP
	GROUP  BY
		CD_EMP
		,CD_FILIAL
		,CD_CX
		,NR_DOC
		,CFOP
		,ALIQ_ICMS
		,VLR_ICMS_SUBS_DARE
		,TIPO
		,TIPO_DOC
		,TIPO_ORIGEM_DEST
		,CD_TRIB_FC
		,VLR_IPI
		,UF_DEST
		,UF_FILIAL
		,DS_MOV_OP
		,PERC_IVA
		,DT_ENT
		,ICMS_CRED_DEB
		,SERVICO 
		,PERC_FECOP_ST      
		,PERC_FECOP_RET      
		,PERC_FECOP
		,CST_PIS
		,CST_COFINS
		,NR_NCM	
		,FLAG_NAO_GERAR_ARQ_SPED	            
		,CD_NAT_RECEITA
		,RECEITA_ISENTA
		,TP_SR_NFE
		,NOTA_CUPOM
		,VLDESC
		,PERC_ALIQ_PIS
		,PERC_ALIQ_COFINS
	    ,PERC_RED_BASE_CALC_EFET 
	    ,PERC_ICMS_EFET  
	    ,PERC_ICMS_RET 
	    ,PERC_ST 
		,NOTA_SERVICO
		,DT_COMP
		,TEMP.FLAG_VLR_ICMS_DESONERADO_DESCONTO
		,TEMP.VLR_ICMS_DESONERADO
		,CD_BENEF_IT
		,CD_BENEF_RED_IT
		,UF_FIL
		,FLAG_FECOP_NAO_APURA_ICMS